// import 3ddashboard utils before imports requiring static ressources (such as vuetify webfonts)
import { widget, disableDefaultCSS, requirejs, onVisibilityChange } from "@widget-lab/3ddashboard-utils";
import Vue from "vue";
import App from "./components/app.vue";
import vuetify from "./plugins/vuetify";
import { store } from "./store";
if (process.env.NODE_ENV === "development" && process.env.devVariables?.vue?.useExternalDebugger) {
    // Ping devtools before trying to connect in order to avoid error message loop...
    fetch("http://localhost:8098/socket.io/")
        .then(() => import("@vue/devtools"))
        .then(devtools => devtools.connect())
        .catch(() => {
            /* eslint-disable no-console */
            console.warn("DevTools not started. Open another terminal, run 'npm run devtools' and reload the widget to use them.");
            /* eslint-enable no-console */
        });
}

const start = () => {
    disableDefaultCSS(true);

    widget.setTitle("Widget Template Vue");

    const mainComponent = new Vue({
        store,
        vuetify,
        render: h => h(App)
    });

    mainComponent.$mount("app");

    requirejs(["DS/PlatformAPI/PlatformAPI"], (/* PlatformAPI */) => {
        // use 3DDashboard APIs
    });

    onVisibilityChange((/* visibility */) => {
        // widget (or fullpage) visibility has changed
        // you can enable/disable periodic data refresh based on visibility
    });
};

/**
 * Entry point for both standalone & 3DDashboard modes
 */
widget.addEvent("onLoad", () => {
    start();
});
widget.addEvent("onRefresh", () => {
    // TODO an application data refresh
    // meaning only refresh dynamic content based on remote data, or after preference changed.
    // we could reload the frame [ window.location.reload() ], but this is not a good practice, since it reset preferences
});
